#ifndef __CADSREditor__
#define __CADSREditor__

#include "CControl.hpp"
#include <MathTools/CBounds.hpp>
using Exponent::GUI::Controls::CControl;
using Exponent::MathTools::CBounds;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CADSREditor CADSREditor.hpp
			 * @brief Allows you to edit an envelope, essential a four contrller fixed setup
			 *
			 * @date 01/06/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CADSREditor.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CADSREditor : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CADSREditor(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CADSREditor();

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Handle a mouse leaving the root area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event);

//	===========================================================================

				/**
				 * Get a value
				 * @param index The index, 0=A, 1=D, 2=S, 3=R
				 * @retval double The scaled value in range 0 - 1
				 */
				virtual double getValue(const long index) { return m_values[index]; }

				/**
				 * Set the value at a specific index (ADSR)
				 * @param index The index, 0=A, 1=D, 2=S, 3=R
				 * @param value The normalised value to set (0 - 1 range)
				 */
				virtual void setValue(const long index, const double value);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * @enum EADSRHandles
				 * @brief Enumeration of the (internal) handles
				 */
				enum EADSRHandles
				{
					e_noSelection = -1,			/**< Nothing selected */

					e_attackSelected,			/**< Attack selected */
					e_decaySelected,			/**< Decay selected */
					e_sustainSelected,			/**< Sustain selected */
					e_releaseSelected,			/**< Release selected */

					e_numberOfHandles,			/**< Total number of handles */
				};

//	===========================================================================

				const static long CADSR_EDITOR_WINDOW_OFFSET = 4;				/**< Offset from the edges */
				const static long CADSR_EDITOR_HANDLE_SIZE = 8;					/**< Size of a handle */
				const static long CADSR_EDITOR_HANDLE_HALF_SIZE = 4;			/**< Size of square offset */

//	===========================================================================

				/**
				 * Move attack
				 * @param event The mouse event to move the attack using
				 */
				void moveAttack(CMouseEvent &event);

				/**
				 * Move decay
				 * @param event The mouse event to move the decay using
				 */
				void moveDecay(CMouseEvent &event);

				/**
				 * Move the sustain
				 * @param event The mouse event to move the sustain using
				 */
				void moveSustain(CMouseEvent &event);

				/**
				 * Move the release
				 * @param event The mouse event to move the release using
				 */
				void moveRelease(CMouseEvent &event);

				/**
				 * Construct the handle positions
				 */
				void constructHandlePositions();

//	===========================================================================

				bool m_mouseIsOver;						/**< Is the mouse over our area? */
				bool m_mouseDown;						/**< Is the mouse down? */
				long m_selectedPoint;					/**< What are we mousing with (-1 if nothing) */
				long m_sizeOfQuarter;					/**< How big is 1/4 of the available space */
				long m_innerHeight;						/**< Height inside */
				long m_innerWidth;						/**< Width inside */

				CPolygon m_envelopePolygon;				/**< The actual envelope curve */
				CRect m_handles[e_numberOfHandles];		/**< The handles that the user can grab */

				double m_values[4];						/**< The values of each stage */
			};
		}
	}
}
#endif	// End of CADSREditor.hpp